% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRISP_functions.R
\name{plot.cvError}
\alias{plot.cvError}
\title{Plots Cross-Validation Curve for \code{\link{crispCV}}.}
\usage{
\method{plot}{cvError}(x, showSE = T, ...)
}
\arguments{
\item{x}{An object of class \code{cvError}, which results from calling \code{\link{summary}} on an object of class \code{\link{crispCV}}.}

\item{showSE}{A logical value indicating whether the standard error of the curve should be plotted.}

\item{...}{Additional arguments to be passed, which are ignored in this function.}
}
\value{
None.
}
\description{
This function plots the cross-validation curve for a series of models fit using \code{\link{crispCV}}. The cross-validation error with +/-1 standard error is plotted for each value of lambda considered in the call to \code{\link{crispCV}} with a dotted vertical line indicating the chosen lambda.
}
\examples{
\dontrun{
#See ?'crisp-package' for a full example of how to use this package

#generate data (using a very small 'n' for illustration purposes)
set.seed(1)
data <- sim.data(n = 15, scenario = 2)

#fit model and select lambda using 2-fold cross-validation
#note: use larger 'n.fold' (e.g., 10) in practice
crispCV.out <- crispCV(X = data$X, y = data$y, n.fold = 2)

#plot the cross-validation error
plot(summary(crispCV.out))
}
}

