% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.r
\name{add_cookies}
\alias{add_cookies}
\title{Add Cookies to the Browser}
\usage{
add_cookies(cookiefile, cookiestring, session, domain = NULL, confirm = FALSE)
}
\arguments{
\item{cookiefile}{A character string indicating the path to the cookie file.}

\item{cookiestring}{A character string representing the cookie in string
format.}

\item{session}{A live html session created with \link[rvest]{read_html_live}
(only version >= 1.0.4).}

\item{domain}{An optional parameter that specifies the host/domain. It's only
used when \code{cookiestring} is provided.}

\item{confirm}{If \code{TRUE}, you confirm to write the cookie jar to disk
(if it does not exist yet) without seeing the interactive menu.}
}
\value{
No explicit return. Instead, this function stores the cookies using
the \code{store_cookies} function.
}
\description{
This function allows you to add browser cookies to the cookie storage. It can
work with either a cookie file or a direct cookie string (e.g., copied from a
CURL call). But remember, just like in real life, you can't have your cookie
and eat it too - pick only one!
}
\note{
You can't provide both a cookiefile and a cookiestring at the same
time. That's like trying to dunk two cookies in a tiny cup of milk!

Your cookies are saved in an encrypted file. See \link{encrypt_vec} for
more info.
}
\examples{
# to conform with CRAN policies, examples use a temporary location. Do not use
# the options like this, except you want your cookies gone when closing R.
options(cookie_dir = tempdir())

# Using a cookie file:
# to conform with CRAN policies, examples use a temporary location. Do not use
# the options like this, except you want your cookies gone when closing R.
add_cookies(cookiefile = system.file("extdata", "cookies.txt", package = "cookiemonster"))

# Using a cookie string:
add_cookies(cookiestring = "username=johndoe; password=secret", domain = "www.example.com")

}
\seealso{
\code{\link{store_cookies}}
}
