% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_dot_env.R
\name{load_dot_env}
\alias{load_dot_env}
\title{Load environment variables from the specified file}
\usage{
load_dot_env(fpath = ".env")
}
\arguments{
\item{fpath}{The path to the `.env` config file}
}
\value{
A named list of environment variables, where names are
the variable names and values are the variable values
}
\description{
The file is parsed, and line is expected to have one of the
 following formats:
\preformatted{VARIABLE=value
VARIABLE2="quoted value"
VARIABLE3='another quoted variable'
# Comment line
export EXPORTED="exported variable"
export EXPORTED2=another}
}
\details{
Load variables defined in the given file, as environment
variables.


Detailed specification:
\itemize{
  \item A leading \code{export} is ignored, to keep the file
     compatible with Unix shells.
  \item No whitespace is allowed right before or after the
     equal sign, again, to promote compatilibity with Unix shells.
  \item No multi-line variables are supported currently. The
     file is strictly parsed line by line.
  \item Unlike for Unix shells, unquoted values are \emph{not}
     terminated by whitespace.
  \item Comments start with \code{#}, without any leading
     whitespace. You cannot mix variable definitions and
     comments in the same line.
  \item Empty lines (containing whitespace only) are ignored.
}

It is suggested to keep the file in a form that is parsed the
same way with \code{dotenv} and \code{bash} (or other shells).
}
\examples{
# Load from a file
tmp <- tempfile()

cat("dotenvexamplefoo=bar\n", file = tmp)
load_dot_env(tmp)

# Clean up
unlink(tmp)
}
