% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{with_penalty}
\alias{with_penalty}
\title{Add penalty term to log-likelihood}
\usage{
with_penalty(loglike, penalty, lambda = 1)
}
\arguments{
\item{loglike}{Base log-likelihood function}

\item{penalty}{Penalty function taking theta and returning numeric}

\item{lambda}{Penalty weight (non-negative numeric, default: 1.0)}
}
\value{
Transformed log-likelihood function
}
\description{
Transforms a log-likelihood by subtracting a penalty term. Useful for
regularized estimation (e.g., LASSO, Ridge regression).
}
\examples{
\donttest{
# Regression with L2 penalty (Ridge)
loglike <- function(theta) -sum((theta - c(1, 2))^2)

# Add L2 penalty
loglike_penalized <- with_penalty(
  loglike,
  penalty = penalty_l2(),
  lambda = 0.1
)
loglike_penalized(c(1, 2))  # Evaluate penalized likelihood
}
}
