% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{compose_transforms}
\alias{compose_transforms}
\title{Compose Multiple Function Transformations}
\usage{
compose_transforms(...)
}
\arguments{
\item{...}{Transformer functions}
}
\value{
Composed transformer function
}
\description{
Applies transformations right-to-left (like mathematical composition).
This allows building complex log-likelihood transformations from simple ones.
}
\details{
Note: For composing solvers, use \code{\link{compose}} instead.
}
\examples{
\donttest{
# Create a composition of transformations
transform <- compose_transforms(
  function(f) with_penalty(f, penalty_l1(), lambda = 0.01),
  function(f) with_penalty(f, penalty_l2(), lambda = 0.05)
)

# Apply to log-likelihood
loglike <- function(theta) -sum((theta - c(1, 2))^2)
loglike_transformed <- transform(loglike)
loglike_transformed(c(1, 2))
}
}
