% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose}
\alias{diagnose}
\title{Diagnostics for cellMarker signatures}
\usage{
diagnose(object, group = NULL, angle_cutoff = 30, weak = 2)
}
\arguments{
\item{object}{A 'cellMarkers' or 'deconv' class object.}

\item{group}{Character vector to focus on cell subclasses within a particular
group or groups.}

\item{angle_cutoff}{Angle in degrees below which cell cluster vectors are
considered to overlap too much. Range 0-90. See \code{\link[=cos_similarity]{cos_similarity()}}.}

\item{weak}{Number of 1st ranked genes for each cell cluster at which/below
its gene set is considered weak.}
}
\value{
No return value. Prints information about the cellMarkers
signature showing cells subclasses with weak signatures and diagnostic
information including which cell subclasses each problematic signature
spills into.
}
\description{
Diagnostic tool which prints information for identifying cell subclasses or
groups with weak signatures.
}
