% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_operations.R
\name{apply_operations}
\alias{apply_operations}
\title{Apply Operation Sequence}
\usage{
apply_operations(state, operations, k)
}
\arguments{
\item{state}{Integer vector representing the initial permutation state}

\item{operations}{Character vector of operations to apply sequentially}

\item{k}{Integer, the parameter for reverse_prefix operations}
}
\value{
Integer vector representing the state after all operations
}
\description{
Applies a sequence of operations to a permutation state. Operations can be
specified as "L"/"1" (shift left), "R"/"2" (shift right), or "X"/"3"
(reverse first k elements).
}
\examples{
# Basic usage with numeric codes
apply_operations(1:5, c("1", "3"), k = 3)

# TopSpin puzzle example
start_state <- 1:20
operations <- c("1", "3", "2")  # Left, Reverse(4), Right
result <- apply_operations(start_state, operations, k = 4)
print(result)

# Using letter codes
apply_operations(1:5, c("L", "X", "R"), k = 3)
}
