% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_discovery.R
\name{search_census_vectors}
\alias{search_census_vectors}
\title{Query the CensusMapper API for vectors with descriptions matching a search term or phrase (deprecated)}
\usage{
search_census_vectors(searchterm, dataset, type = NA, ...)
}
\arguments{
\item{searchterm}{The term or phrase to search for e.g. \code{"Ojibway"}.
Search terms are case insensitive. If unable to find a given string,
this function will suggest similarly named objects.}

\item{dataset}{The dataset to query for available vectors, e.g.
\code{"CA16"}.}

\item{type}{One of \code{NA}, \code{'Total'}, \code{'Male'} or \code{'Female'}.
If specified, only return variables of specified `type`.}

\item{...}{Further arguments passed on to \code{\link{list_census_vectors}}.}
}
\description{
Query the CensusMapper API for vectors with descriptions matching a search term or phrase (deprecated)
}
\examples{
\dontrun{
search_census_vectors('Ojibway', 'CA16')

# This will return a warning that no match was found, but will suggest similar terms.
search_census_vectors('Ojibwe', 'CA16', 'Total')
}
}
