% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimData.R
\name{SimData}
\alias{SimData}
\title{Simulate dataset}
\usage{
SimData(
  n = 100,
  M = 5,
  sigsq.true = 0.5,
  beta.true = 2,
  hfun = 3,
  Zgen = "norm",
  ind = 1:2,
  family = "gaussian"
)
}
\arguments{
\item{n}{Number of observations}

\item{M}{Number of predictor variables to generate}

\item{sigsq.true}{Variance of normally distributed residual error}

\item{beta.true}{Coefficient on the covariate}

\item{hfun}{An integer from 1 to 3 identifying which predictor-response function to generate}

\item{Zgen}{Method for generating the matrix Z of exposure variables, taking one of the values c("unif", "norm", "corr", "realistic")}

\item{ind}{select which predictor(s) will be included in the \code{h} function; how many predictors that can be included will depend on which \code{h} function is being used.}

\item{family}{a description of the error distribution and link function to be used in the model. Currently implemented for \code{gaussian} and \code{binomial} families.}
}
\value{
a list containing the parameter values and generated variables of the simulated datasets
}
\description{
Simulate predictor, covariate, and continuous outcome data
}
\details{
\itemize{
 \item \code{hfun = 1}: A nonlinear function of the first predictor 
 \item \code{hfun = 2}: A linear function of the first two predictors and their product term
 \item \code{hfun = 3}: A nonlinear and nonadditive function of the first two predictor variables
}
}
\examples{
set.seed(5)
dat <- SimData()
}
