% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorResponseFunctions.R
\name{PredictorResponseBivarLevels}
\alias{PredictorResponseBivarLevels}
\title{Plot cross-sections of the bivariate predictor-response function}
\usage{
PredictorResponseBivarLevels(
  pred.resp.df,
  Z = NULL,
  qs = c(0.25, 0.5, 0.75),
  both_pairs = TRUE,
  z.names = NULL
)
}
\arguments{
\item{pred.resp.df}{object obtained from running the function \code{\link{PredictorResponseBivar}}}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{qs}{vector of quantiles at which to fix the second variable}

\item{both_pairs}{flag indicating whether, if \code{h(z1)} is being plotted for z2 fixed at different levels, that they should be plotted in the reverse order as well (for \code{h(z2)} at different levels of z1)}

\item{z.names}{optional vector of names for the columns of \code{z}}
}
\value{
a long data frame with the name of the first predictor, the name of the second predictor, the value of the first predictor, the quantile at which the second predictor is fixed, the posterior mean estimate, and the posterior standard deviation of the estimated exposure response function
}
\description{
Function to plot the \code{h} function of a particular variable at different levels (quantiles) of a second variable
}
\details{
For guided examples, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
\examples{
## First generate dataset
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)

## Obtain predicted value on new grid of points for each pair of predictors
## Using only a 10-by-10 point grid to make example run quickly
pred.resp.bivar <- PredictorResponseBivar(fit = fitkm, min.plot.dist = 1, ngrid = 10)
pred.resp.bivar.levels <- PredictorResponseBivarLevels(pred.resp.df = pred.resp.bivar, 
Z = Z, qs = c(0.1, 0.5, 0.9))
}
