% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datastore.R
\name{register_azure_data_lake_gen2_datastore}
\alias{register_azure_data_lake_gen2_datastore}
\title{Initialize a new Azure Data Lake Gen2 Datastore.}
\usage{
register_azure_data_lake_gen2_datastore(
  workspace,
  datastore_name,
  filesystem,
  account_name,
  tenant_id,
  client_id,
  client_secret,
  resource_url = NULL,
  authority_url = NULL,
  protocol = NULL,
  endpoint = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{workspace}{The workspace this datastore belongs to.}

\item{datastore_name}{The datastore name.}

\item{filesystem}{The name of the Data Lake Gen2 filesystem.}

\item{account_name}{The storage account name.}

\item{tenant_id}{The Directory ID/Tenant ID of the service principal.}

\item{client_id}{The Client ID/Application ID of the service principal.}

\item{client_secret}{The secret of the service principal.}

\item{resource_url}{The resource URL, which determines what operations will be
performed on the data lake store, defaults to https://storage.azure.com/ which
allows us to perform filesystem operations.}

\item{authority_url}{The authority URL used to authenticate the user, defaults to
"https://login.microsoftonline.com".}

\item{protocol}{Protocol to use to connect to the blob container. If None,
defaults to "https".}

\item{endpoint}{The endpoint of the blob container. If None, defaults to
"core.windows.net".}

\item{overwrite}{Whether to overwrite an existing datastore. If the datastore
does not exist, it will create one. The default is FALSE.}
}
\value{
The \code{azureml.data.azure_data_lake_datastore.AzureDataLakeGen2Datastore}
object.
}
\description{
Initialize a new Azure Data Lake Gen2 Datastore.
}
\section{Examples}{
\if{html}{\out{<div class="r">}}\preformatted{# Create and register an Azure Data Lake Gen2 Datastore to a workspace.

my_adlsgen2_ds <- register_azure_data_lake_gen2_datastore(workspace = your_workspace,
                                                          datastore_name = <name for this datastore>,
                                                          filesystem = 'test',
                                                          tenant_id = your_workspace$auth$tenant_id,
                                                          client_id = your_workspace$auth$service_principal_id,
                                                          client_secret = your_workspace$auth$service_principal_password)
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=unregister_datastore]{unregister_datastore()}}, \code{\link[=get_datastore]{get_datastore()}}
}
