% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_update_service}
\alias{ecs_update_service}
\title{Update Service}
\usage{
ecs_update_service(
  cluster = NULL,
  service = NULL,
  desiredCount = NULL,
  taskDefinition = NULL,
  capacityProviderStrategy = NULL,
  deploymentConfiguration = NULL,
  networkConfiguration = NULL,
  placementConstraints = NULL,
  placementStrategy = NULL,
  platformVersion = NULL,
  forceNewDeployment = NULL,
  healthCheckGracePeriodSeconds = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that your service is running on.}

\item{service}{Character. The name of the service to update.}

\item{desiredCount}{Integer. The number of instantiations of the task to place and keep running in your service.}

\item{taskDefinition}{Character. The \code{family} and \code{revision} (\code{family:revision}) or full ARN of the task definition to run in your...}

\item{capacityProviderStrategy}{List.   The capacity provider strategy to update the service to use.}

\item{deploymentConfiguration}{Object. Optional deployment parameters that control how many tasks run during the deployment and the ordering...}

\item{networkConfiguration}{No description can be found.}

\item{placementConstraints}{List.   An array of task placement constraint objects to update the service to use.}

\item{placementStrategy}{List.   The task placement strategy objects to update the service to use.}

\item{platformVersion}{Character. The platform version on which your tasks in the service are running.}

\item{forceNewDeployment}{Logical. Whether to force a new deployment of the service.}

\item{healthCheckGracePeriodSeconds}{Integer. The period of time, in seconds, that the Amazon ECS service scheduler should ignore unhealthy Elastic...}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Update Service
}
\section{cluster}{

The short name
or full Amazon Resource Name (ARN) of the cluster that your service is
running on. If you do not specify a cluster, the default cluster is
assumed.
}

\section{service}{

The name of the service to
update.
}

\section{desiredCount}{

The number of instantiations of the task to
place and keep running in your service.
}

\section{taskDefinition}{

The \code{family}
and \code{revision} (\code{family:revision}) or full ARN of the task definition to
run in your service. If a \code{revision} is not specified, the latest
\code{ACTIVE} revision is used. If you modify the task definition with
\code{UpdateService}, Amazon ECS spawns a task with the new version of the
task definition and then stops an old task after the new version is
running.
}

\section{capacityProviderStrategy}{


The capacity provider strategy to update the service to use.

If the service is using the default capacity provider strategy for the
cluster, the service can be updated to use one or more capacity
providers as opposed to the default capacity provider strategy. However,
when a service is using a capacity provider strategy that is not the
default capacity provider strategy, the service cannot be updated to use
the cluster\'s default capacity provider strategy.

A capacity provider strategy consists of one or more capacity providers
along with the \code{base} and \code{weight} to assign to them. A capacity
provider must be associated with the cluster to be used in a capacity
provider strategy. The PutClusterCapacityProviders API is used to
associate a capacity provider with a cluster. Only capacity providers
with an \code{ACTIVE} or \code{UPDATING} status can be used.

If specifying a capacity provider that uses an Auto Scaling group, the
capacity provider must already be created. New capacity providers can be
created with the CreateCapacityProvider API operation.

To use a AWS Fargate capacity provider, specify either the \code{FARGATE} or
\code{FARGATE_SPOT} capacity providers. The AWS Fargate capacity providers
are available to all accounts and only need to be associated with a
cluster to be used.

The PutClusterCapacityProviders API operation is used to update the list
of available capacity providers for a cluster after the cluster is
created.
}

\section{deploymentConfiguration}{

Optional deployment parameters that control how
many tasks run during the deployment and the ordering of stopping and
starting tasks.
}

\section{networkConfiguration}{

No description can be found.
}

\section{placementConstraints}{


An array of task placement constraint objects to update the service to
use. If no value is specified, the existing placement constraints for
the service will remain unchanged. If this value is specified, it will
override any existing placement constraints defined for the service. To
remove all existing placement constraints, specify an empty array.

You can specify a maximum of 10 constraints per task (this limit
includes constraints in the task definition and those specified at
runtime).
}

\section{placementStrategy}{


The task placement strategy objects to update the service to use. If no
value is specified, the existing placement strategy for the service will
remain unchanged. If this value is specified, it will override the
existing placement strategy defined for the service. To remove an
existing placement strategy, specify an empty object.

You can specify a maximum of five strategy rules per service.
}

\section{platformVersion}{

The platform version on which your tasks in the
service are running. A platform version is only specified for tasks
using the Fargate launch type. If a platform version is not specified,
the \code{LATEST} platform version is used by default. For more information,
see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html}{AWS Fargate Platform Versions}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}

\section{forceNewDeployment}{

Whether to force a new deployment of the
service. Deployments are not forced by default. You can use this option
to trigger a new deployment with no service definition changes. For
example, you can update a service\'s tasks to use a newer Docker image
with the same image/tag combination (\code{my_image:latest}) or to roll
Fargate tasks onto a newer platform version.
}

\section{healthCheckGracePeriodSeconds}{

The
period of time, in seconds, that the Amazon ECS service scheduler should
ignore unhealthy Elastic Load Balancing target health checks after a
task has first started. This is only valid if your service is configured
to use a load balancer. If your service\'s tasks take a while to start
and respond to Elastic Load Balancing health checks, you can specify a
health check grace period of up to 2,147,483,647 seconds. During that
time, the Amazon ECS service scheduler ignores the Elastic Load
Balancing health check status. This grace period can prevent the ECS
service scheduler from marking tasks as unhealthy and stopping them
before they have time to come up.
}

