% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_request_spot_instances}
\alias{ec2_request_spot_instances}
\title{Request Spot Instances}
\usage{
ec2_request_spot_instances(
  AvailabilityZoneGroup = NULL,
  BlockDurationMinutes = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  InstanceCount = NULL,
  LaunchGroup = NULL,
  LaunchSpecification = NULL,
  SpotPrice = NULL,
  Type = NULL,
  ValidFrom = NULL,
  ValidUntil = NULL,
  TagSpecification = NULL,
  InstanceInterruptionBehavior = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{AvailabilityZoneGroup}{Character.   The user-specified name for a logical grouping of requests.[optional]}

\item{BlockDurationMinutes}{Integer.   The required duration for the Spot Instances (also known as Spot blocks), in minutes.[optional]}

\item{ClientToken}{Character. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{InstanceCount}{Integer.   The maximum number of Spot Instances to launch.  Default: 1  [optional]}

\item{LaunchGroup}{Character.   The instance launch group.[optional]}

\item{LaunchSpecification}{Object. The launch specification.[optional]}

\item{SpotPrice}{Character. The maximum price per hour that you are willing to pay for a Spot Instance.[optional]}

\item{Type}{Character.   The Spot Instance request type.  Default: \code{one-time}  [optional]}

\item{ValidFrom}{Character.   The start date of the request.[optional]}

\item{ValidUntil}{Character.   The end date of the request, in UTC format (\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).[optional]}

\item{TagSpecification}{List. The key-value pair for tagging the Spot Instance request on creation.[optional]}

\item{InstanceInterruptionBehavior}{Character. The behavior when a Spot Instance is interrupted. The default is \code{terminate}.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Request Spot Instances
}
\section{AvailabilityZoneGroup}{


The user-specified name for a logical grouping of requests.

When you specify an Availability Zone group in a Spot Instance request,
all Spot Instances in the request are launched in the same Availability
Zone. Instance proximity is maintained with this parameter, but the
choice of Availability Zone is not. The group applies only to requests
for Spot Instances of the same instance type. Any additional Spot
Instance requests that are specified with the same Availability Zone
group name are launched in that same Availability Zone, as long as at
least one instance from the group is still active.

If there is no active instance running in the Availability Zone group
that you specify for a new Spot Instance request (all instances are
terminated, the request is expired, or the maximum price you specified
falls below current Spot price), then Amazon EC2 launches the instance
in any Availability Zone where the constraint can be met. Consequently,
the subsequent set of Spot Instances could be placed in a different zone
from the original request, even if you specified the same Availability
Zone group.

Default: Instances are launched in any available Availability Zone.
}

\section{BlockDurationMinutes}{


The required duration for the Spot Instances (also known as Spot
blocks), in minutes. This value must be a multiple of 60 (60, 120, 180,
240, 300, or 360).

The duration period starts as soon as your Spot Instance receives its
instance ID. At the end of the duration period, Amazon EC2 marks the
Spot Instance for termination and provides a Spot Instance termination
notice, which gives the instance a two-minute warning before it
terminates.

You can\'t specify an Availability Zone group or a launch group if you
specify a duration.

New accounts or accounts with no previous billing history with AWS are
not eligible for Spot Instances with a defined duration (also known as
Spot blocks).
}

\section{ClientToken}{

Unique, case-sensitive identifier that you provide
to ensure the idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{How to Ensure Idempotency}
in the \emph{Amazon EC2 User Guide for Linux
Instances}.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{InstanceCount}{


The maximum number of Spot Instances to launch.

Default: 1
}

\section{LaunchGroup}{


The instance launch group. Launch groups are Spot Instances that launch
together and terminate together.

Default: Instances are launched and terminated individually
}

\section{LaunchSpecification}{

The launch specification.
}

\section{SpotPrice}{

The
maximum price per hour that you are willing to pay for a Spot Instance.
The default is the On-Demand price.
}

\section{Type}{


The Spot Instance request type.

Default: \code{one-time}
}

\section{ValidFrom}{


The start date of the request. If this is a one-time request, the
request becomes active at this date and time and remains active until
all instances launch, the request expires, or the request is canceled.
If the request is persistent, the request becomes active at this date
and time and remains active until it expires or is canceled.

The specified start date and time cannot be equal to the current date
and time. You must specify a start date and time that occurs after the
current date and time.
}

\section{ValidUntil}{


The end date of the request, in UTC format
(\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).
\itemize{
\item For a persistent request, the request remains active until the
\code{ValidUntil} date and time is reached. Otherwise, the request
remains active until you cancel it.
\item For a one-time request, the request remains active until all
instances launch, the request is canceled, or the \code{ValidUntil} date
and time is reached. By default, the request is valid for 7 days
from the date the request was created.
}
}

\section{TagSpecification}{

The key-value pair for tagging the Spot Instance
request on creation. The value for \code{ResourceType} must be
\code{spot-instances-request}, otherwise the Spot Instance request fails. To
tag the Spot Instance request after it has been created, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html}{CreateTags}.
}

\section{InstanceInterruptionBehavior}{

The behavior when a Spot Instance is interrupted.
The default is \code{terminate}.
}

