% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adbcpostgresql-package.R
\name{adbcpostgresql}
\alias{adbcpostgresql}
\alias{adbc_database_init.adbcpostgresql_driver_postgresql}
\alias{adbc_connection_init.adbcpostgresql_database}
\alias{adbc_statement_init.adbcpostgresql_connection}
\title{ADBC PostgreSQL Driver}
\usage{
adbcpostgresql()

\method{adbc_database_init}{adbcpostgresql_driver_postgresql}(driver, ..., uri)

\method{adbc_connection_init}{adbcpostgresql_database}(database, ..., adbc.connection.autocommit = NULL)

\method{adbc_statement_init}{adbcpostgresql_connection}(
  connection,
  ...,
  adbc.ingest.target_table = NULL,
  adbc.ingest.target_db_schema = NULL,
  adbc.ingest.mode = NULL
)
}
\arguments{
\item{driver}{An \code{\link[adbcdrivermanager:adbc_driver]{adbc_driver()}}.}

\item{...}{Driver-specific options. For the default method, these are
named values that are converted to strings.}

\item{uri}{A URI to a database path (e.g.,
\verb{postgresql://localhost:1234/postgres?user=user&password=password})}

\item{database}{An \link[adbcdrivermanager:adbc_database_init]{adbc_database}.}

\item{adbc.connection.autocommit}{Use FALSE to disable the default
autocommit behaviour.}

\item{connection}{An \link[adbcdrivermanager:adbc_connection_init]{adbc_connection}}

\item{adbc.ingest.target_table}{The name of the target table for a bulk insert.}

\item{adbc.ingest.target_db_schema}{The schema of the table for a bulk insert.}

\item{adbc.ingest.mode}{Whether to create (the default) or append.}
}
\value{
An \code{\link[adbcdrivermanager:adbc_driver_void]{adbcdrivermanager::adbc_driver()}}
}
\description{
ADBC PostgreSQL Driver
}
\examples{
adbcpostgresql()

}
