% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{which_nearest}
\alias{which_nearest}
\title{Find the index of value nearest to a target value}
\usage{
which_nearest(values, target, dir)
}
\arguments{
\item{values}{numeric vector, the values considered.}

\item{target}{single numeric value, the target to find the value closest to.}

\item{dir}{single numeric value. If \code{0} (the default), finds the index of the
value closest to the target, regardless of the direction. If \verb{< 0} or
\verb{> 0}, finds the index of the value closest to the target, but only
considers values at or below/above target, respectfully, if any (otherwise
returns the closest value regardless of direction).}
}
\value{
Single integer, the index of the value closest to \code{target} according
to \code{dir}.
}
\description{
Used internally, to find the index of the value in a vector nearest to a
target value, possibly in a specific preferred direction.
}
\keyword{internal}
