% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activeC.R
\name{update.const_C}
\alias{update.const_C}
\title{C update with new observations}
\usage{
\method{update}{const_C}(object, Xnew, Znew, ...)
}
\arguments{
\item{object}{A const_C object, the result of a call to the C_GP function.}

\item{Xnew}{matrix (one point per row) corresponding to the new designs}

\item{Znew}{vector of size \code{nrow(Xnew)} for the new responses at \code{Xnew}}

\item{...}{not used (for consistency of update method)}
}
\value{
The updated const_C object originally provided.
}
\description{
Update Constantine's C with new point(s) for a GP
}
\examples{
\donttest{ 
################################################################################
### Active subspace of a Gaussian process
################################################################################
library(hetGP); library(lhs)
set.seed(42)

nvar <- 2
n <- 100

# theta gives the subspace direction
f <- function(x, theta, nugget = 1e-3){
  if(is.null(dim(x))) x <- matrix(x, 1)
  xact <- cos(theta) * x[,1] - sin(theta) * x[,2]
  return(hetGP::f1d(xact) + 
    rnorm(n = nrow(x), sd = rep(nugget, nrow(x))))
}

theta_dir <- pi/6
act_dir <- c(cos(theta_dir), -sin(theta_dir))

# Create design of experiments and initial GP model
design <- X <- matrix(signif(maximinLHS(n, nvar), 2), ncol = nvar)
response <- Y <- apply(design, 1, f, theta = theta_dir)
model <- mleHomGP(design, response, known = list(beta0 = 0))

C_hat <- C_GP(model)

print(C_hat)
print(subspace_dist(C_hat, matrix(act_dir, nrow = nvar), r = 1))

# New designs
Xnew <- matrix(runif(2), 1)
Znew <- f(Xnew, theta_dir)

C_new <- update(C_hat, Xnew, Znew)
print(C_new)
subspace_dist(C_new, matrix(act_dir, nrow = nvar), r = 1)
}
}
\seealso{
\code{\link[activegp]{C_GP}} to generate const_C objects from \code{\link[hetGP]{mleHomGP}} objects; \code{\link[activegp]{update_C2}} for an update using faster expressions.
}
