% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reranker.R
\name{AdvancedReranker}
\alias{AdvancedReranker}
\title{Advanced Reranker with Learned Weights}
\description{
Combines multiple signals for better reranking:
\itemize{
\item Semantic similarity (word vectors)
\item BM25/keyword overlap
\item Query coverage
\item Position bias
\item Length normalization
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{weights}}{Feature weights}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AdvancedReranker-new}{\code{AdvancedReranker$new()}}
\item \href{#method-AdvancedReranker-set_embedder}{\code{AdvancedReranker$set_embedder()}}
\item \href{#method-AdvancedReranker-rerank}{\code{AdvancedReranker$rerank()}}
\item \href{#method-AdvancedReranker-learn_weights}{\code{AdvancedReranker$learn_weights()}}
\item \href{#method-AdvancedReranker-clone}{\code{AdvancedReranker$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AdvancedReranker-new"></a>}}
\if{latex}{\out{\hypertarget{method-AdvancedReranker-new}{}}}
\subsection{Method \code{new()}}{
Create a new AdvancedReranker
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AdvancedReranker$new(
  semantic_weight = 0.4,
  bm25_weight = 0.3,
  coverage_weight = 0.2,
  position_weight = 0.1,
  sentence_embedder = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{semantic_weight}}{Weight for semantic similarity (0-1)}

\item{\code{bm25_weight}}{Weight for BM25 score (0-1)}

\item{\code{coverage_weight}}{Weight for query term coverage (0-1)}

\item{\code{position_weight}}{Weight for position bias (0-1)}

\item{\code{sentence_embedder}}{Optional SentenceEmbedder for semantic scoring}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AdvancedReranker-set_embedder"></a>}}
\if{latex}{\out{\hypertarget{method-AdvancedReranker-set_embedder}{}}}
\subsection{Method \code{set_embedder()}}{
Set sentence embedder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AdvancedReranker$set_embedder(embedder)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{embedder}}{SentenceEmbedder object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AdvancedReranker-rerank"></a>}}
\if{latex}{\out{\hypertarget{method-AdvancedReranker-rerank}{}}}
\subsection{Method \code{rerank()}}{
Rerank results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AdvancedReranker$rerank(
  query,
  query_vector = NULL,
  results,
  doc_vectors = NULL,
  limit = 10
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query text}

\item{\code{query_vector}}{Query embedding vector}

\item{\code{results}}{List of result objects with id, text, score}

\item{\code{doc_vectors}}{Matrix of document vectors (optional)}

\item{\code{limit}}{Number of results to return}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Reranked list of results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AdvancedReranker-learn_weights"></a>}}
\if{latex}{\out{\hypertarget{method-AdvancedReranker-learn_weights}{}}}
\subsection{Method \code{learn_weights()}}{
Learn optimal weights from relevance judgments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AdvancedReranker$learn_weights(
  queries,
  results_list,
  relevance_list,
  iterations = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{queries}}{Character vector of queries}

\item{\code{results_list}}{List of result lists (one per query)}

\item{\code{relevance_list}}{List of relevance scores (1=relevant, 0=not)}

\item{\code{iterations}}{Number of optimization iterations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AdvancedReranker-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AdvancedReranker-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AdvancedReranker$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
