% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WeightsGLcv}
\alias{WeightsGLcv}
\title{Site gauged linear coefficient of variation (Lcv) weightings}
\usage{
WeightsGLcv(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
A data.frame with site references in the first column and associated weights in the second
}
\description{
Provides the gauged Lcv weights for each site in a pooling group
}
\details{
Weighting method as according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation
}
\examples{
# Get some CDs, form a gauged pooling group, and estimate gauged Lcv
cds_27051 <- GetCDs(27051)
pool_27051 <- Pool(cds_27051)
WeightsGLcv(pool_27051)

}
\author{
Anthony Hammond
}
