% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{monthly_return}
\alias{monthly_return}
\title{Compute Monthly Returns of a Vector.}
\usage{
monthly_return(vec)
}
\arguments{
\item{vec}{a numeric vector of asset returns.}
}
\value{
A numeric vector of monthly returns.
}
\description{
This function takes a numeric vector of asset returns and computes monthly returns.
}
\note{
The input data must be an xts object with dates as rownames.
}
\examples{

# Compute monthly returns of an asset vector
require(xts)
asset_returns_xts <- xts(c(29.2, 30.0, 36.2, 30.4, 38.5, -35.6, 34.5),
                         order.by = as.Date(c("2022-05-02", "2022-06-02", "2022-07-02",
                                             "2022-08-02", "2022-09-02", "2022-10-02",
                                             "2022-11-02")))
monthly_return(asset_returns_xts)


}
\seealso{
\code{\link{weekly_return}}, \code{\link{annual_return}}
}
