% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_matern.R
\name{kernel_matern}
\alias{kernel_matern}
\title{Matern covariance function}
\usage{
kernel_matern(x, sigma, kappa, nu = 1, X1 = NULL, X2 = NULL)
}
\arguments{
\item{x}{Distance measure.}

\item{sigma}{Positive scale parameter.}

\item{kappa}{Positive inverse range/lengthscale parameter.}

\item{nu}{Smoothness parameter default to 1.}

\item{X1}{A \verb{n1 x 2} matrix containing the coordinates of location set 1.
If \code{x} is not provided, \code{X1} and \code{X2} should be provided for calculating their distance.}

\item{X2}{A \verb{n2 x 2} coordinate matrix.}
}
\value{
A matrix or a scalar of Matern covariance depending on the type of \code{x} or
whether \code{X1} and \code{X2} are used instead.
}
\description{
Matern covariance function
}
\details{
Let x = dist(x_i, x_j).

\if{html}{\out{<div class="sourceCode">}}\preformatted{cov(i,j) = sigma^2 * 2^(1-nu)/gamma(nu) * (kappa*x)^nu * K_v(kappa*x)
}\if{html}{\out{</div>}}

Note that when \code{nu=0.5}, the Matern kernel corresponds to the absolute exponential kernel.
}
\examples{
X1 <- cbind(runif(10, 1, 10), runif(10, 10, 20))
X2 <- cbind(runif(5, 1, 10), runif(5, 10, 20))

kernel_matern(sigma=2, kappa=1, X1=X1, X2=X2)

kernel_matern(as.matrix(stats::dist(X1)), sigma=2, kappa=1)
}
