% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Soil_Salinity_Indices.R
\name{Soil_Salinity_Indices}
\alias{Soil_Salinity_Indices}
\title{Generation of Soil Salinity Indices using Satellite Data}
\usage{
Soil_Salinity_Indices(
  B = NULL,
  G = NULL,
  R = NULL,
  NIR = NULL,
  SW1 = NULL,
  SW2 = NULL
)
}
\arguments{
\item{B}{Raster layer representing the Blue band (default NULL)}

\item{G}{Raster layer representing the Green band (default NULL)}

\item{R}{Raster layer representing the Red band (default NULL)}

\item{NIR}{Raster layer representing the Near-Infrared band (default NULL)}

\item{SW1}{Raster layer representing the Shortwave Infrared band 1 (default NULL)}

\item{SW2}{Raster layer representing the Shortwave Infrared band 2 (default NULL)}
}
\value{
RasterStack of relevant salinity indices based on available input bands
}
\description{
Generation of Soil Salinity Indices using Satellite Data
}
\examples{
\donttest{
library(SoilSaltIndex)
library (raster)
# Example usage:
B <- raster::raster(system.file("extdata", "Blue.tif", package = "SoilSaltIndex"))
G <- raster::raster(system.file("extdata", "Green.tif", package = "SoilSaltIndex"))
R <- raster::raster(system.file("extdata", "Red.tif", package = "SoilSaltIndex"))
NIR <- raster::raster(system.file("extdata", "NIR.tif", package = "SoilSaltIndex"))
SW1 <- raster::raster(system.file("extdata", "SWIR1.tif", package = "SoilSaltIndex"))
SW2 <- raster::raster(system.file("extdata", "SWIR2.tif", package = "SoilSaltIndex"))
Salt_Index <- Soil_Salinity_Indices(B=B, G=G, R=R, NIR=NIR, SW1=SW1, SW2=SW2)
Salt_Index <- Soil_Salinity_Indices(SW1=SW1, SW2=SW2)
Salt_Index <- Soil_Salinity_Indices(B=B, G=G, R=R, NIR=NIR)
}
}
\references{
1. Rani, A., Kumar, N., Sinha, N. K., & Kumar, J. (2022). Identification of salt-affected soils using remote sensing data through random forest technique: a case study from India. Arabian Journal of Geosciences, 15(5), 381.<DOI:10.1007/s12517-022-09682-3>
2. Kumar et al. (2023). SpatGRID:Spatial Grid Generation from Longitude and Latitude List. R package version 0.1.0.
}
