% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_means_vars.R
\name{compute_means_vars}
\alias{compute_means_vars}
\title{Compute Summary Statistics for a List of Datasets}
\usage{
compute_means_vars(data_list)
}
\arguments{
\item{data_list}{A list of numeric matrices or data frames. Each entry should be a matrix or data frame with numeric values.}
}
\value{
A named list containing:
\itemize{
\item Overall mean and SD for each dataset.
\item Average row-wise mean and SD.
\item Average column-wise mean and SD.
\item \code{mean_smp}: Average row-wise mean across all datasets.
\item \code{sd_smp}: Average row-wise SD across all datasets.
}
}
\description{
Computes overall, row-wise, and column-wise means and standard deviations for each dataset in a list. Also provides average statistics across datasets.
}
\examples{
# Example using simulated matrices
set.seed(123)
dataset1 <- matrix(rnorm(100, mean = 5, sd = 2), nrow = 10, ncol = 10)
dataset2 <- matrix(rnorm(100, mean = 10, sd = 3), nrow = 10, ncol = 10)
data_list <- list(dataset1, dataset2)
results <- compute_means_vars(data_list)
print(results)

\dontrun{
# Example using real experimental data (requires MOFAdata)
if (requireNamespace("MOFAdata", quietly = TRUE)) {
  utils::data("CLL_data", package = "MOFAdata")
  CLL_data2 <- CLL_data[c(2, 3)]
  results <- compute_means_vars(CLL_data2)
  print(results)
}
}
}
