% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsearch_obj.R
\name{phyloseq2rsearch}
\alias{phyloseq2rsearch}
\title{Convert phyloseq object to Rsearch object}
\usage{
phyloseq2rsearch(phyloseq.obj)
}
\arguments{
\item{phyloseq.obj}{(Required). A phyloseq object, see
\code{\link[phyloseq]{phyloseq}}.}
}
\value{
A \code{list} with entries as in a Rsearch object, except that the
\code{sequence.tbl} do not contain sequences, only taxonomy.
}
\description{
Creating an Rsearch object (list) from a phyloseq object.
}
\details{
This function converts a phyloseq object to a simple
\code{\link{list}} with three elements as dataframes (or tibbles). The
entries are named according to the structure used in
\code{\link{rsearch_obj}}
}
\examples{
\dontrun{
# Convert phyloseq object to Rsearch object
rsearch_obj <- phyloseq2rsearch(phy_obj)

# Extract read count data
rsearch_obj$readcount.mat

# Extract sample data
rsearch_obj$sampledata.df

# Extract sequence data
rsearch_obj$sequence.df
}

}
\references{
\url{https://joey711.github.io/phyloseq/}
}
\seealso{
\code{\link{rsearch_obj}}
}
