% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RHRVEasy.R
\name{RHRVEasy}
\alias{RHRVEasy}
\title{Run a full HRV analysis including indices computation and statistical analysis}
\usage{
RHRVEasy(
  folders,
  correctionMethod = c("bonferroni", "holm", "hochberg", "hommel", "BH", "BY", "fdr",
    "none"),
  verbose = FALSE,
  format = "RR",
  typeAnalysis = c("fourier", "wavelet"),
  significance = 0.05,
  nonLinear = FALSE,
  doRQA = FALSE,
  nJobs = 1,
  saveHRVIndicesInPath = NULL,
  ...
)
}
\arguments{
\item{folders}{A character vector with the paths to the folders containing
the HRV files. Each folder should contain the HRV files of a group.}

\item{correctionMethod}{The method to correct for multiple comparisons. Can
be one of "bonferroni", "holm", "hochberg", "hommel", "BH", "BY", "fdr" and
"none". Default is "bonferroni".}

\item{verbose}{Logical. If TRUE, the function will show a progress bar and
print additional information to the console.}

\item{format}{The format of the HRV files. Can be one of "WFDB", "Ascii",
"RR", "Polar", "Suunto", "EDFPlus" and "Ambit".}

\item{typeAnalysis}{The type of frequency analysis to perform. Can be one of
"fourier" or "wavelet".}

\item{significance}{The significance level to use in the statistical
analysis. By default, it is set to 0.05.}

\item{nonLinear}{Logical. If TRUE, the function will compute non-linear
indices. It should be noted that this process is computationally expensive.}

\item{doRQA}{Logical. If TRUE, the function will compute Recurrence
Quantification Analysis (RQA) indices. This parameter is ignored if
`nonLinear` is set to FALSE.It should be noted that this process is
computationally expensive.}

\item{nJobs}{The number of parallel jobs to use. `nJobs <= 0` uses all cores
available. By default, it is set to 1.}

\item{saveHRVIndicesInPath}{The path where the HRV indices will be saved as
an excel file. If NULL, the indices will not be saved. See [SaveHRVIndices()]
for more details.}

\item{...}{Additional arguments for the HRV analysis. For further details,
see the `RHRV` package.}
}
\value{
An object of class `RHRVEasyResult` containing the HRV indices
(slot `$HRVIndices`) and the statistical analysis results (slot `$stats`)
}
\description{
Run a full HRV analysis including indices computation and statistical analysis
}
