% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPowerBand.R
\name{PlotSinglePowerBand}
\alias{PlotSinglePowerBand}
\title{PlotSinglePowerBand}
\usage{
PlotSinglePowerBand(
  HRVData,
  indexFreqAnalysis = length(HRVData$FreqAnalysis),
  band = c("LF", "HF", "ULF", "VLF", "LF/HF"),
  normalized = FALSE,
  main = paste(band, "Power Band"),
  xlab = "Time",
  ylab = paste("Power in", band),
  type = "l",
  Tags = NULL,
  Indexes = NULL,
  eplim = NULL,
  epColorPalette = NULL,
  markEpisodes = TRUE,
  ymark = NULL,
  showEpLegend = TRUE,
  epLegendCoords = NULL,
  Tag = NULL,
  ...
)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and 
information related to it}

\item{indexFreqAnalysis}{Numeric parameter used to reference a particular
frequency analysis}

\item{band}{The frequency band to be plotted. Allowd bands are "ULF", "VLF", "LF" 
(default), "HF" and "LF/HF")}

\item{normalized}{Plots normalized powers if TRUE}

\item{main}{A main title for the plot.}

\item{xlab}{A label for the x axis.}

\item{ylab}{A label for the y axis}

\item{type}{1-character string giving the type of plot desired. See 
\code{\link[graphics]{plot.default}}.}

\item{Tags}{List of tags to specify which episodes, as
apnoea or oxygen desaturation, are included in the plot.
\emph{Tags}="all" plots all episodes present in the data.}

\item{Indexes}{List of indexes of episodes (see \code{\link{ListEpisodes}})
to specify which episodes are included in the plot. 
\emph{Indexes}="all" plots all episodes present in the data.}

\item{eplim}{Two-component vector specifying the y-range (min,max) for the
vertical lines limiting each episode.}

\item{epColorPalette}{Vector specifying the color of each of the episodes that 
will be plotted. The length of colorPalette should be equal or greater than 
the number of different episodes to be plotted.}

\item{markEpisodes}{Boolean specyfing if a horizontal mark should be included 
for each of the episodes.}

\item{ymark}{Two-component vector specifying the y-range (min,max) for the
horizontal marks. Only used if markEpisodes = TRUE.}

\item{showEpLegend}{Boolean argument. If TRUE, a legend of the episodes is 
included.}

\item{epLegendCoords}{Two-component vector specifiying the coordinates where
the legend should be placed. By defaul, the legend is placed on top of the
plot.}

\item{Tag}{Deprecated argument maintained for
compatibility, use Tags instead}

\item{...}{Other graphical parameters for plotting the power band. See 
\code{\link[graphics]{plot.default}}.}
}
\description{
Plots a concrete power band computed by the CalculatePowerBand 
function
}
\examples{
\dontrun{

# Read file "a03" from the physionet apnea-ecg database
library(RHRV)
HRVData <- CreateHRVData()
HRVData <- LoadBeatWFDB(HRVData,RecordName="test_files/WFDB/a03")
HRVData <- LoadApneaWFDB(HRVData,RecordName="test_files/WFDB/a03")
# Calculating heart rate signal:
HRVData <- BuildNIHR(HRVData)
 
# Filtering heart rate signal:
HRVData <- FilterNIHR(HRVData)

# Interpolating heart rate signal:
HRVData = InterpolateNIHR(HRVData)

HRVData = CreateFreqAnalysis(HRVData)
HRVData = CalculatePowerBand(HRVData, indexFreqAnalysis = 1,
          size = 300, shift = 60, sizesp = 1024)
          
layout(matrix(1:4, nrow = 2))
PlotSinglePowerBand(HRVData, 1, "VLF", Tags = "APNEA", epColorPalette = "red",
                    epLegendCoords = c(2000,7500))
PlotSinglePowerBand(HRVData, 1, "LF", Tags = "APNEA", epColorPalette = "red",
                    eplim = c(0,6000),
                    markEpisodes = F, showEpLegend = FALSE)
PlotSinglePowerBand(HRVData, 1, "HF", Tags = "APNEA", epColorPalette = "red",
                    epLegendCoords = c(2000,1700))
PlotSinglePowerBand(HRVData, 1, "LF/HF", Tags = "APNEA", epColorPalette = "red",
                    eplim = c(0,20),
                    markEpisodes = F, showEpLegend = FALSE)
# Reset layout
par(mfrow = c(1,1))
}
}
\seealso{
\code{\link{CalculatePowerBand}} for power calculation
}
