% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StationaryFrequencyAnalysis.R
\name{PlotPSD}
\alias{PlotPSD}
\title{Plot Spectral Density Estimation}
\usage{
PlotPSD(
  HRVData,
  indexFreqAnalysis = length(HRVData$FreqAnalysis),
  ULFmin = 0,
  ULFmax = 0.03,
  VLFmin = 0.03,
  VLFmax = 0.05,
  LFmin = 0.05,
  LFmax = 0.15,
  HFmin = 0.15,
  HFmax = 0.4,
  log = "y",
  type = "l",
  xlab = "Frequency (Hz) ",
  ylab = "Spectrum",
  main = NULL,
  xlim = c(min(ULFmin, ULFmax, VLFmin, VLFmax, LFmin, LFmax, HFmin, HFmax), max(ULFmin,
    ULFmax, VLFmin, VLFmax, LFmin, LFmax, HFmin, HFmax)),
  ylim = NULL,
  addLegend = TRUE,
  addSigLevel = TRUE,
  usePalette = c("#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442"),
  ...
)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information 
related to it.}

\item{indexFreqAnalysis}{An integer referencing the data structure that contains 
the PSD analysis.}

\item{ULFmin}{Lower limit ULF band used for distinguish the ULF band.}

\item{ULFmax}{Upper limit ULF band used for distinguish the ULF band.}

\item{VLFmin}{Lower limit VLF band.}

\item{VLFmax}{Upper limit VLF band.}

\item{LFmin}{Lower limit LF band.}

\item{LFmax}{Upper limit LF band.}

\item{HFmin}{Lower limit HF band.}

\item{HFmax}{Upper limit HF band.}

\item{log}{a character string which contains "x" if the x axis is to be
logarithmic,  "y" if the y axis is to be logarithmic and "xy" or "yx" if 
both axes are to be logarithmic. Default: "y".}

\item{type}{1-character string giving the type of plot desired. See \code{\link[graphics]{plot.default}}.}

\item{xlab}{a label for the x axis. See \code{\link[graphics]{plot.default}}.}

\item{ylab}{a label for the y axis. See \code{\link[graphics]{plot.default}}.}

\item{main}{a main title for the plot. See \code{\link[graphics]{plot.default}}.}

\item{xlim}{the x limits (x1, x2) of the plot. See \code{\link[graphics]{plot.default}}.}

\item{ylim}{the y limits of the plot.}

\item{addLegend}{add a simple legend? Default: True.}

\item{addSigLevel}{Logical value (only used with the lomb method). If true an
horizontal line limiting the significance level is included ( Powers >
 sig.level can be considered significant peaks). See \code{\link[lomb]{lsp}}.}

\item{usePalette}{A new palette of colors for plotting the frequency bands.}

\item{...}{graphical parameters. See \code{\link[graphics]{plot.default}}.}
}
\description{
Plot the PSD estimate of the RR time series distinguishing
the different frequency bands with different colurs.
}
\examples{
\dontrun{
data(HRVData)
HRVData=BuildNIHR(HRVData)
HRVData=FilterNIHR(HRVData)
# Frequency analysis requires interpolated data (except Lomb)
HRVData=InterpolateNIHR(HRVData)
# Create a different freqAnalysis for each method
HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,1,"pgram",doPlot = F)

HRVData=CalculatePSD(HRVData,2,"pgram",spans=9,doPlot = F)

HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,3,"ar",doPlot = F)

HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,4,"lomb",doPlot = F)
# Plot the results
layout(matrix(c(1,2,3,4), 2, 2, byrow = TRUE))
PlotPSD(HRVData,1)
PlotPSD(HRVData,2)
PlotPSD(HRVData,3)
PlotPSD(HRVData,4)
}
}
\seealso{
\code{\link[stats]{spectrum}}, \code{\link[lomb]{lsp}}, \code{\link[RHRV]{CalculatePSD}}.
}
