% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_full_multilateral_indices.R
\name{gekslm}
\alias{gekslm}
\title{Calculating the multilateral GEKS-LM price index}
\usage{
gekslm(data, start, end, sigma = 0.7, wstart = start, window = 13)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{sigma}{The elasticity of substitution (a parameter used in the Lloyd-Moulton index formula).}

\item{wstart}{The beginning of the time interval (which is used by multilateral methods) limited to the year and month, e.g. "2020-01".}

\item{window}{The length of the time window (as positive integer: typically multilateral methods are based on the 13-month time window).}
}
\value{
This function returns a value of the multilateral GEKS-LM price index (to be more precise: the GEKS index based on the Lloyd-Moulton price index) which considers the time window defined by \code{wstart} and \code{window} parameters. It measures the price dynamics by comparing period \code{end} to period \code{start} (both \code{start} and \code{end} must be inside the considered time window). To get information about both price index values and corresponding dates, please see functions: \code{\link{price_indices}} or \code{\link{final_index}}. The function does not take into account aggregating over outlets or product subgroups (to consider these types of aggregating, please use the \code{\link{final_index}} function).
}
\description{
This function returns a value of the multilateral GEKS-LM price index (to be more precise: the GEKS index based on the Lloyd-Moulton price index).
}
\examples{
\donttest{gekslm(milk, start="2019-01", end="2019-08",window=10)}
\donttest{gekslm(milk, start="2018-12", end="2019-12", sigma=0.5)}
}
\references{
{Gini, C. (1931). \emph{On the Circular Test of Index Numbers.} Metron 9:9, 3-24.}

{Elteto, O., and Koves, P. (1964). \emph{On a Problem of Index Number Computation Relating to International Comparisons.} Statisztikai Szemle 42, 507-518.}

{Szulc, B. (1983). \emph{Linking Price Index Numbers.} In: Price Level Measurement, W. E. Diewert and C. Montmarquette (eds.), 537-566.}

{Lloyd, P. J. (1975). \emph{Substitution Effects and Biases in Nontrue Price Indices.}  The American Economic Review, 65, 301-313.}

{Moulton,  B.  R.  (1996). \emph{Constant  Elasticity  Cost-of-Living  Index  in  Share-Relative  Form.}  Washington DC: U. S. Bureau of Labor Statistics, mimeograph}
}
