% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_general.R
\name{final_index}
\alias{final_index}
\title{A general function to compute a final price index}
\usage{
final_index(
  data = data.frame(),
  start = c(),
  end = c(),
  formula = c(),
  window = c(),
  splice = c(),
  base = c(),
  sigma = c(),
  r = c(),
  outlets = FALSE,
  groups = FALSE,
  by = c(),
  aggr = "fisher",
  interval = FALSE
)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities} (as positive numeric) and \code{prodID} (as numeric, factor or character). A column \code{retID} (as numeric, factor or character) is also essential if the aggregation over outlets is considered. A column with grouping variable (as numeric, factor or character - indicated by the \code{by} parameter) is essential if the aggregation over product subgroups is considered.}

\item{start}{The base period (as character) limited to the year and month, e.g. "2019-12".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{formula}{The character string indicating the price index formula is to be calculated. To see available options please use the link: \code{\link{PriceIndices}}.}

\item{window}{The length of the time window if the multilateral index is selected (as positive integer: typically multilateral methods are based on the 13-month time window).}

\item{splice}{A character string indicating the splicing method (if the multilateral splicing index is selected). Available options are: "movement", "window","half","mean" and their additional variants: "window_published", "half_published" and "mean_published".}

\item{base}{The prior period used in the Young- or Lowe-type price indices (as character) limited to the year and month, e.g. "2020-01".}

\item{sigma}{The elasticity of substitution parameter used in the Lloyed-Moulton, AG Mean or GEKS-LM indices (as numeric).}

\item{r}{The non-zero parameter used in the quadratic mean of order r quantity / price index or in the GEKS-QM index (as numeric).}

\item{outlets}{A logical parameter indicating whether the aggregation over outlets (defined by \code{retID} column) should be done.}

\item{groups}{A logical parameter indicating whether the aggregation over product subgroups (indicated by 'by' parameter) should be done.}

\item{by}{A character string which indicates a column name for creating product subgroups.}

\item{aggr}{The formula used for aggregating partial index results (available values are: "arithmetic", "geometric", "laspeyres", "paasche", "fisher", "tornqvist").}

\item{interval}{A logical value indicating whether the function is to provide price indices comparing the research period defined by \code{end} to the base period defined by \code{start} (then \code{interval} is set to FALSE) or all fixed base indices are to be presented (the fixed base month is defined by \code{start}).}
}
\value{
This general function returns a value or values of the selected final price index for the selected type of aggregation of partial results. If the \code{interval} parameter is set to TRUE, then it returns a data frame where its first column indicates dates and the remaining columns show corresponding values of all selected price indices.
}
\description{
This function returns a value (or values) of the selected final price index for the selected type of aggregation of partial results.
}
\examples{
\donttest{final_index(coffee, start = "2018-12", end = "2019-12", 
         formula = "fisher", groups = TRUE, outlets = FALSE, 
         aggr = "tornqvist", by = "description")}
\donttest{final_index(milk, start = "2018-12", end = "2019-12", 
         formula = "fisher", groups = TRUE, outlets = TRUE, 
         aggr = "laspeyres", by = "description", 
         interval = TRUE)}
}
