% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSAR.R
\name{simSAR}
\alias{simSAR}
\title{Simulating Linear Peer Effect Models}
\usage{
simSAR(formula, Glist, parms, lambda, beta, epsilon, nthreads = 1, data)
}
\arguments{
\item{formula}{An object of class \link[stats]{formula}: a symbolic description of the model. \code{formula} should be specified as, for example, \code{~ x1 + x2},
where \code{x1} and \code{x2} are control variables, which can include contextual variables such as averages or quantiles among peers.}

\item{Glist}{The adjacency matrix. For networks consisting of multiple subnets (e.g., schools), \code{Glist} must be a list of subnets, with the \code{m}-th element being an \eqn{n_m \times n_m} adjacency matrix, where \eqn{n_m} is the number of nodes in the \code{m}-th subnet.}

\item{parms}{A vector defining the true values of \eqn{(\lambda', \beta')'}, where
\eqn{\lambda} is the peer effect parameter and \eqn{\beta} is the parameter vector of control variables (including contextual variables if any).
The parameters \eqn{\lambda} and \eqn{\beta} can also be specified separately using the arguments \code{lambda}, and \code{beta}.}

\item{lambda}{The true value of the vector \eqn{\lambda}.}

\item{beta}{The true value of the vector \eqn{\beta}.}

\item{epsilon}{A vector of idiosyncratic error terms. If not specified, it will be simulated from a standard normal distribution.}

\item{nthreads}{A strictly positive integer indicating the number of threads to use.}

\item{data}{An optional data frame, list, or environment (or an object that can be coerced by \link[base]{as.data.frame} to a data frame) containing the variables
in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically the environment from which \code{simSAR} is called.}
}
\value{
A list containing:
\item{y}{The simulated variable.}
\item{Gy}{the average of y among friends.}
}
\description{
\code{simSAR} simulates linear peer effect models.
}
\examples{
set.seed(123)
ngr  <- 50
nvec <- rep(30, ngr)
n    <- sum(nvec)
G    <- lapply(1:ngr, function(z){
  Gz <- matrix(rbinom(nvec[z]^2, 1, 0.3), nvec[z])
  diag(Gz) <- 0
  Gz/rowSums(Gz) # Row-normalized network
})
X    <- cbind(rnorm(n), rpois(n, 2))
l    <- 0.5
b    <- c(2, -0.5, 1)

out  <- simSAR(formula = ~ X, Glist = G, lambda = l, beta = b)
summary(out$y)
}
\seealso{
\code{\link{smmSAR}}, \code{\link{mcmcSAR}}
}
