% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sel_herb.R
\name{sel_herb}
\alias{sel_herb}
\title{Surviving the herbicide}
\usage{
sel_herb(start, result, thresh, sdrate, rate, put, max_vec_length = 1e+07)
}
\arguments{
\item{start}{column names of parental cohorts. \code{character vector}.}

\item{result}{name of the results column. \code{character}.}

\item{thresh}{threshold herbicide rate to kill weeds without resistance. \code{numeric}, \eqn{0 \le \code{thresh} \le 1}.}

\item{sdrate}{variance of the herbicide rate reaching the weed. \code{positive numeric}, 1 = 1 unit standard deviation.}

\item{rate}{percentage (\%) of the registered herbicide dose. \code{positive numeric}, can exceed 100 \%.}

\item{put}{probability of a weed to be untouched by the herbicide. \code{numeric}, \eqn{0 \le \code{put} \le 1}.}

\item{max_vec_length}{used internally, a technical term, defining the maximum length of vectors to be used.}
}
\description{
\code{sel_herb} calculates the surviving number of each genotype. \code{sel_herb} selects for resistant individuals.
}
\details{
For every genotype \code{\link{intern_herbicide}} is called. If no genetics are included, the value from \code{start} is returned in \code{result}.
}
\examples{
struc_preparation2(Rmx=10, af=c(0.02,0.01), epis=0, dom=1)
gen_freq( af=c(0.01,0.8), n_seeds=10000)
sel_herb(start="initialSB", result="winter", 
                       thresh=20, sdrate=0.4, rate=100, put=0.04)
}
\seealso{
\code{\link{sel_resist}}
}
