% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_diploid.R
\name{gen_diploid}
\alias{gen_diploid}
\title{Diploid genetics: recombination of alleles}
\usage{
gen_diploid(
  start,
  start_comb = NA,
  result,
  newseeds = get0("newseeds", envir = parent.frame(n = 1)),
  max_vec_length = 1e+07
)
}
\arguments{
\item{start}{column names of parental cohorts. \code{character vector}.}

\item{start_comb}{all named columns in \code{start} are joined and returned as a column with the name of \code{start_comb} (\code{character}). Only used when \code{start} longer than 1.}

\item{result}{name of the results column. \code{character}.}

\item{newseeds}{number of new seeds calculated by \code{\link{pop_reprod}}. \code{positive} \code{integer}.}

\item{max_vec_length}{used internally, a technical term, defining the maximum length of vectors to be used.}
}
\value{
A column with the name of \code{result} and, if necessary, a column with the name of \code{start_comb} is added to the \code{data.frame} \code{dfgenotype}.
}
\description{
\code{gen_diploid} recombines the alleles of weeds with diploid genome.
}
\details{
\code{gen_diploid} assumes independent allele recombination.
}
\section{warning}{
 newseeds are always coerced to a whole number.
}

\examples{
\dontrun{
# generate a 'dfgenotype' data.frame:
struc_preparation2(Rmx=10, af=c(0.01, 0.2), epis=0, dom=1)
#Distribute 10000 individuals of the starting population across the genotypes. 
#The two gene loci have initial frequencies of 0.01 and 0.8.
gen_freq(af=c(0.01,0.8), n_seeds=10000)
# The column "initialSB" represents the parent generation, which recombines and 
#therefore defines the genetics of the new seeds
newseeds <- 10000
gen_diploid(start="initialSB", result="followingSB")
# If a second cohort is reprodusing in the same time
gen_diploid(start=c("initialSB", "followingSB"), 
                  start_comb="two_cohorts_combind", result="followingSB2")
rm(dfgenotype, mf, newseeds, xprobab)
}
}
\seealso{
\code{\link{pop_reprod}}
}
