% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.PPtreeExtclass.R
\name{predict.PPtreeExtclass}
\alias{predict.PPtreeExtclass}
\title{Predict Method for Projection Pursuit Classification Tree Extensions}
\usage{
\method{predict}{PPtreeExtclass}(object, newdata, true.class = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"PPtreeExtclass"} from 
\code{\link{PPtreeExtclass}} or \code{\link{PPtreeExt_split}}.}

\item{newdata}{A data frame or matrix containing the predictor variables for 
which predictions are to be made. Must contain the same variables (in the same 
order) as used in the training data, but without the class variable.}

\item{true.class}{Optional vector of true class labels for the test data. 
If provided, prediction error will be calculated. Can be either numeric or 
factor. Default is \code{NULL}.}

\item{...}{Additional arguments (currently not used).}
}
\value{
A list with two components:
\item{predict.class}{A character vector of predicted class labels for each 
  observation in \code{newdata}.}
\item{predict.error}{Integer count of prediction errors (misclassifications). 
  Only computed when \code{true.class} is provided; otherwise returns \code{NA}.}
}
\description{
Predicts class labels for new observations using a fitted projection pursuit 
classification tree and optionally calculates prediction error when true class 
labels are provided.
}
\examples{
data(penguins)
penguins <- na.omit(penguins[, -c(2,7, 8)])
require(rsample)
penguins_spl <- rsample::initial_split(penguins, strata=species)
penguins_train <- training(penguins_spl)
penguins_test <- testing(penguins_spl)
penguins_ppt <- PPtreeExtclass(species~bill_len + bill_dep +
flipper_len + body_mass, data = penguins_train, PPmethod = "LDA", tot =nrow
(penguins_train), tol=0.5)
predict(object = penguins_ppt, newdata = penguins_test[,-1], true.class = penguins_test$species)
}
\keyword{tree}
