% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeExt.construct.R
\name{TreeExt.construct}
\alias{TreeExt.construct}
\title{Projection pursuit classification tree extensions}
\usage{
TreeExt.construct(origclass, origdata, Tree.Struct, id, rep, rep1, rep2,
projbest.node, splitCutoff.node, PPmethod, 
lambda = NULL, q = 1, weight = TRUE, srule=TRUE, tot=NULL, tol = .5,...)
}
\arguments{
\item{origclass}{factor or numeric vector containing the class labels for each observation.}

\item{origdata}{data frame with the original data without class variable}

\item{Tree.Struct}{tree structure of projection pursuit classification tree}

\item{id}{tree node id}

\item{rep}{internal counter for nodes}

\item{rep1}{internal counter for nodes}

\item{rep2}{internal counter for nodes}

\item{projbest.node}{bests projection node}

\item{splitCutoff.node}{cutof node}

\item{PPmethod}{method for projection pursuit; "LDA", "PDA"}

\item{lambda}{lambda in PDA index}

\item{q}{numeric value with dimension of the projected data, if it is 1 then 1D projection is used}

\item{weight}{weight flag in LDA, PDA}

\item{srule}{stopping rule flag; if TRUE use stopping rule, if FALSE stop only for pure or empty nodes}

\item{tot}{total number of observations}

\item{tol}{tolerance value for entropy stopping rule for splitting a node}

\item{...}{additional arguments to pass trough}
}
\value{
A list containing the complete tree structure and node information:
  \item{Tree.Struct}{A matrix where each row represents a node in the projection pursuit classification tree. The matrix has 5 columns:
    \itemize{
      \item Column 1: Node ID
      \item Column 2: ID of the left child node (or 0 if terminal node)
      \item Column 3: ID of the right child node, or the predicted class label if terminal node
      \item Column 4: Projection index (which projection vector is used at this node)
      \item Column 5: Optimization criterion value for the projection at this node
    }
  }
  \item{projbest.node}{A matrix where each row contains the optimal projection coefficients (Alpha vector) for each split node.}
  \item{splitCutoff.node}{A matrix/vector containing the optimal cutpoint values used at each split node.}
  \item{rep}{Integer counter tracking the current node being processed (internal use).}
  \item{rep1}{Integer counter for assigning child node IDs (internal use).}
  \item{rep2}{Integer counter for tracking projection indices (internal use).}
}
\description{
Construct the projection pursuit classification tree extensions
}
\details{
Find tree structure using various projection pursuit indices of 
classification in each split.


This function recursively constructs a binary classification tree using projection pursuit. 
At each node, it finds the optimal projection direction that best separates classes, 
determines a cutpoint, and creates child nodes until stopping criteria are met 
(pure nodes, small node size, or low entropy).
}
