% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Microsoft365R.R
\name{microsoft365r_options}
\alias{microsoft365r_options}
\alias{microsoft365r_global}
\title{Global options}
\description{
Microsoft365R has a number of global options that affect how it interacts with the underlying Graph API.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{options(microsoft365r_use_itemid_in_path = TRUE)
options(microsoft365r_use_outlook_immutable_ids = TRUE)
}\if{html}{\out{</div>}}
}

\section{Details}{

The \code{microsoft365r_use_itemid_in_path} option controls when to use item IDs in requests for OneDrive/SharePoint drive items. The default value of TRUE means to use this always; other possible values are FALSE (the default in previous versions of Microsoft365R) and "remote" (use only when dealing with items shared by another user).

The \code{microsoft365r_use_outlook_immutable_ids} option controls whether to use immutable object IDs in Outlook. Immutable IDs have the advantage that they don't change when an email is moved or copied between folders, whereas traditional Outlook object IDs can change. The default is to use immutable IDs; set this option to FALSE to revert to traditional Outlook IDs.
}

