% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showMutations.R
\name{showMutations}
\alias{showMutations}
\title{Summarize mutations}
\usage{
showMutations(profile, positions)
}
\arguments{
\item{profile}{An object of class \code{entropyProfile}.}

\item{positions}{A vector with genome positions relative to the reference
genome.}
}
\value{
An object of class \code{c("tidyMutations", "data.frame")},
containing summary information about user-supplied genomic
positions. This information includes the mutations themselves
relative to the reference genome, their positions within it, and the
corresponding abundances in the virome. Intended to be displayed by
\code{print.tidyMutations}.
}
\description{
Displays SNVs, and corresponding protein mutations, at specific genomic
positions.
}
\details{
The user provides a list of genome positions and the function
prints the mutations associated with them.
The output format is "ref_res###alt_res /
protein:ref_res###alt_res", where ref_res is the residue (eiter
nucleotide or aminoacid) in the reference strain, alt_res is the
alternative residue in the metagenome, "###" is the position
(either nucleotide or aminoacid) where the mutation was observed,
and "protein" is the name of the affected protein.
}
\examples{

# High entropy at the RBD in Omicron lineages
omicron <- getEntropySignature(wWater[wWater$wave == "third", ])
plot(omicron, chartType="stripchart")

# Identify the high-entropy positions
omicron$Entropy$position[ omicron$Entropy$entropy > 0.3 ]
#[1] 22882 22898 22917 23013 23040 23048 23055 23063

# Get a descriptive table
showMutations(omicron, c(22882, 22898, 22917, 23013, 23040, 23048, 23055, 23063))


}
\seealso{
\code{\link{getEntropySignature}}.
}
