% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.entropyProfile.R
\name{plot.entropyProfile}
\alias{plot.entropyProfile}
\title{Plot entropy signatures}
\usage{
\method{plot}{entropyProfile}(x, chartType = "bp", ...)
}
\arguments{
\item{x}{Object of class \code{entropyProfile}.}

\item{chartType}{Whether to graph per-protein summaries ("bp"), per-protein
stripcharts ("stripchart" / "swarm"), or position-wise
entropy ("entroScan").}

\item{...}{Additional arguments passed to the function.}
}
\value{
Unrendered \code{gg/ggplot} object produced by \code{ggplot2}. This
function is primarily called for its side effects.
}
\description{
Creates entropy charts along a genome.
}
\examples{
ancestral <- getEntropySignature(wWater[wWater$wave == "first", ])
omicron <- getEntropySignature(wWater[wWater$wave == "third", ])

# Enhanced Spike entropy plus pervasive negative selection in Omicron
# sublineages
anc_plot <- plot(ancestral, chartType = "stripchart")
omi_plot <- plot(omicron, chartType = "stripchart")
patchwork::wrap_plots(anc_plot/omi_plot)


}
