% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillPosition.R
\name{fillPosition}
\alias{fillPosition}
\title{Translate amino acid frequencies into category frequencies}
\usage{
fillPosition(positionSummary, categories)
}
\arguments{
\item{positionSummary}{A data frame created by \code{\link{createPositionSummary}}.}

\item{categories}{A character string indicating which category scheme to
use. Similar to the \code{categories} parameter of
\code{\link{getEntropySignature}}.}
}
\value{
A list with information on the frequencies of each amino acid
category observed in a virome in a specific locus. The list contains
a \code{character} vector for each amino acid category, and a named
\code{numeric} vector containing the frequency of each category in
the metagenome.
}
\description{
The function is used internally by \code{\link{getEntropySignature}}.
It creates a storage list by \code{createStorage}, and loads on it the
frequency of each amino acid category based on the data contained in a data
frame passed to the function (\code{positionsSummary} parameter).
}
\seealso{
\code{\link{getEntropySignature}}.
}
\keyword{internal}
