% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropyProfile.R
\name{entropyProfile}
\alias{entropyProfile}
\title{Create (empty) object of class "entropyProfile"}
\usage{
entropyProfile(
  polymorphisms,
  position = "position",
  linkage = "linkage",
  ref = "ref",
  alt = "alt",
  protein = "protein",
  aa_position = "aa_position",
  ref_aa = "ref_aa",
  alt_aa = "alt_aa",
  alt_aa_freq = "alt_aa_freq",
  entropies = NA_real_,
  genome = mn908947.3
)
}
\arguments{
\item{polymorphisms}{A data frame. Please see Details and Examples in
documentation for \code{\link{getEntropySignature}}.}

\item{position}{Name of the \code{polymorphisms}'s column that indicates SNV
locations in the genome.}

\item{linkage}{Information on linked positions.}

\item{ref}{Column name with reference bases.}

\item{alt}{Column name with the alternative bases observed in the
metagenome.}

\item{protein}{Name of the column carrying protein names.}

\item{aa_position}{Name of the column that indicates the protein positions
of the mutated amino acids.}

\item{ref_aa}{Name of the column that carries the reference amino acids.}

\item{alt_aa}{Name of the column carrying alternative amino acids observed
in the metagenome.}

\item{alt_aa_freq}{Name of the column giving the frequencies of alternative
amino acids in the metagenome.}

\item{entropies}{\code{NA_REAL_} (double numeric/real vector to hold entropy
values).}

\item{genome}{A list providing CDS data and length of the reference genome.}
}
\value{
An (empty) object of class \code{entropyProfile}.
}
\description{
This function is intended primarily for internal use by
\code{\link{getEntropySignature}}.
}
\details{
The documentation for \code{\link{getEntropySignature}} details the type of
input needed to create a profile. \code{entropyProfile} uses the same parameters as
\code{getEntropySignature}, with the exception of \code{categories} and
\code{entropies}.
}
\seealso{
\code{\link{getEntropySignature}}.
}
