% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_variables.R
\name{extract_variables}
\alias{extract_variables}
\title{Roles of variables}
\usage{
extract_variables(model, cat_vars = NULL, cat_vars_nlevels = NULL)
}
\arguments{
\item{model}{Code for fitting a \code{\link[nlme:lme]{nlme::lme()}} or \code{\link[lme4:lmer]{lme4::lmer()}} model given
as a string.}

\item{cat_vars}{Optional character vector of the names of categorical
predictor variables included in the \code{model}. Default is \code{NULL}, which assumes
that all predictor variables are numeric.}

\item{cat_vars_nlevels}{Optional numeric vector of the number of levels (i.e.
categories) for each variable in \code{cat_vars}. Must be a vector of same length
as \code{cat_vars}. Values must be whole numbers greater than \code{1} and less than
\code{10}. Only applies if \code{cat_vars} is not \code{NULL}.}
}
\value{
A data frame.
}
\description{
\code{extract_variables()} returns a data frame of information of the variables in
a \code{\link[nlme:lme]{nlme::lme()}} or \code{\link[lme4:lmer]{lme4::lmer()}} model. The columns of the data frame
include: \code{Effect} (whether the effect is random or fixed), \code{Group} (group or
grouping factor associated with random effects), \code{Term} (notation used to
include the variable in the model), \code{Description} (description of the \code{Term}),
and \code{Parameter} (parameter estimated when the model is fit).
}
\examples{
# lme()
extract_variables(model = "lme(Score~type,random=list(School=pdDiag(~1+type),Class=~1))",
                  cat_vars = "type",
                  cat_vars_nlevels = 2)
extract_variables(model = "lme(weight~1+Time+I(Time^2),random=~Time+I(Time^2)|ID)")

# lmer()
extract_variables(model = "lmer(Strength ~ 1 + (1|Machine) + (1|Worker))")
extract_variables(model = "lmer(score ~ age*treat + (age|subject))",
                  cat_vars = "treat",
                  cat_vars_nlevels = 3)
}
