% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_equation.R
\name{extract_equation}
\alias{extract_equation}
\title{Model equation in 'LaTeX' format}
\usage{
extract_equation(
  model,
  cat_vars = NULL,
  cat_vars_nlevels = NULL,
  output_type = "latex"
)
}
\arguments{
\item{model}{Code for fitting a \code{\link[nlme:lme]{nlme::lme()}} or \code{\link[lme4:lmer]{lme4::lmer()}} model given
as a string.}

\item{cat_vars}{Optional character vector of the names of categorical
predictor variables included in the \code{model}. Default is \code{NULL}, which assumes
that all predictor variables are numeric.}

\item{cat_vars_nlevels}{Optional numeric vector of the number of levels (i.e.
categories) for each variable in \code{cat_vars}. Must be a vector of same length
as \code{cat_vars}. Values must be whole numbers greater than \code{1} and less than
\code{10}. Only applies if \code{cat_vars} is not \code{NULL}.}

\item{output_type}{Output type can be \code{"latex"} (default), \code{"string"}, or
\code{"none"}.}
}
\value{
None (invisible NULL) (\code{output_type = "latex"}), a string
(\code{output_type = "string"}), or no output (\code{output_type = "none"}).
}
\description{
\code{extract_equation()} takes the \code{\link[nlme:lme]{nlme::lme()}} or \code{\link[lme4:lmer]{lme4::lmer()}} code for
fitting a linear mixed effect model and returns the corresponding model
equation written in 'LaTeX' notation.
}
\examples{
# Different ways to write the same lme model
extract_equation(model = "lme(score ~ age, random=~age|subject)")
extract_equation(model = "lme(score ~ age, random=list(subject=~age))")

# Correlated vs. Uncorrelated
extract_equation(model = "lmer(score ~ age + (age|subject))")
extract_equation(model = "lmer(score ~ age + (age||subject))")

# Add a categorical predictor and interaction
extract_equation(model = "lmer(score ~ age*treat + (age|subject))",
                 cat_vars = "treat",
                 cat_vars_nlevels = 3)
}
