% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{importLabels}
\alias{importLabels}
\title{Import the labels for a dimension code (a code list)}
\usage{
importLabels(dimension_code)
}
\arguments{
\item{dimension_code}{A dimension code name (string). Case insensitive.}
}
\value{
A data.table with 2 columns: codes in the first, labels in the second.
If e.g. \code{dimension_code="geo"}, the first column is named \code{geo} and
the second column is named \code{geo__label}.
}
\description{
The available datasets are:
\tabular{ll}{
\strong{dimension_code} \tab \strong{Description} \cr
AGE \tab Age class \cr
EXPTYPE \tab Type of expenditure \cr
GEO \tab Geopolitical entity (reporting) i.e. a country \cr
LMP_TYPE \tab Labour market policy interventions by type of action \cr
flags_ \tab Flags for each statistical observation \cr
REGIS_ES \tab Registration with employment services \cr
SEX \tab Sex / gender \cr
STK_FLOW \tab Stock or flow \cr
UNIT \tab Unit of measure \cr
}
}
\examples{
\donttest{
importLabels("geo")
importLabels("exptype")
}
}
