% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopez_ruzicka.R
\name{sen_lopez_ruzicka_instantaneous2}
\alias{sen_lopez_ruzicka_instantaneous2}
\title{Log-space instantaneous sensitivity via Lopez-Ruzicka decomposition}
\usage{
sen_lopez_ruzicka_instantaneous2(
  mx,
  age = (1:length(mx1)) - 1,
  nx = rep(1, length(mx1)),
  sex = "t",
  perturb = 1e-06,
  closeout = TRUE
)
}
\arguments{
\item{mx}{Numeric vector of mortality rates (central death rates).}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex}{Character; "m" for male, "f" for female, or "t" for total.}

\item{perturb}{Numeric; a small constant determining the perturbation size (default: 1e-6).}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
numeric vector of sensitivity of life expectancy to perturbations in \code{mx}.
}
\description{
Estimates the sensitivity of life expectancy to small changes in mortality rates using the Lopez-Ruzicka decomposition and log-space perturbation. This is done by shifting the log of the input mortality rates up and down by a small constant, then exponentiating, and computing the average directional sensitivity.

Specifically:
\deqn{m_x^{1} = \exp(\ln m_x + h)}
\deqn{m_x^{2} = \exp(\ln m_x - h)}
and applies \code{sen_lopez_ruzicka(mx1, mx2, ...)} and \code{sen_lopez_ruzicka(mx2, mx1, ...)},
returning their average.
}
\details{
This approach gives numerically identical results to
\code{sen_arriaga_sym_instantaneous2()},
\code{sen_chandrasekaran_II_instantaneous2()}, and
\code{sen_chandrasekaran_III_instantaneous2()}.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx <- a * exp(x * b)
s <- sen_lopez_ruzicka_instantaneous2(mx, age = x)
\donttest{
plot(x, s, type = "l")
}
}
\seealso{
\code{\link{sen_lopez_ruzicka_instantaneous}},
\code{\link{sen_arriaga_sym_instantaneous2}},
\code{\link{sen_chandrasekaran_III_instantaneous2}}
}
