% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VSISR_support.R
\name{ps2D_PartialDeriv}
\alias{ps2D_PartialDeriv}
\title{Partial derivative two-dimensional smoothing scattered (normal)
data using P-splines.}
\usage{
ps2D_PartialDeriv(
  Data,
  Pars = rbind(c(min(Data[, 1]), max(Data[, 1]), 10, 3, 1, 2), c(min(Data[, 2]),
    max(Data[, 2]), 10, 3, 1, 2)),
  XYpred = cbind(Data[, 1], Data[, 2])
)
}
\arguments{
\item{Data}{a matrix of 3 columns \code{x, y, z} of equal length;
the response is \code{z}.}

\item{Pars}{a matrix of 2 rows, where the first and second row
sets the P-spline paramters for \code{x} and \code{y}, respectively.
Each row consists of: \code{min max nseg bdeg lambda pord}.
The \code{min} and \code{max} set the ranges, \code{nseg} (default 10)
is the number of evenly spaced segments between \code{min} and \code{max},
\code{bdeg} is the degree of the basis (default 3 for cubic),
\code{lambda} is the (positive) tuning parameter for the penalty (default 1),
\code{pord} is the number for the order of the difference penalty (default 2).}

\item{XYpred}{a matrix with two columns \code{(x, y)} that give the coordinates
of (future) prediction; the default is the data locations.}
}
\value{
\item{coef}{a vector of length \code{(Pars[1, 3] + Pars[1, 4]) * (Pars[1, 3] + Pars[1, 4]).}
of (unfolded) estimated P-spline coefficients.}
\item{B}{the tensor product B-spline matrix of dimensions \code{m} by \code{length(coef)}.}
\item{fit}{a vector of \code{length(y)} of smooth estimated means (at the \code{x, y} locations).}
\item{pred}{a vector of length \code{nrow(XYpred)} of (future) predictions.}
\item{d_coef}{a vector of length \code{(Pars[1, 3] + Pars[1,4] - 1) * (Pars[1,3]+Pars[1,4]).}
of (unfolded) partial derivative estimated P-spline coefficients.}
\item{B_d}{the tensor product B-spline matrix of dimensions \code{m} by \code{lengh(d_coef)}, associated with
the partial derivative of the tensor basis.}
\item{d_fit}{a vector of \code{length(y)} of partial derivative (along \code{x})
of the smooth estimated means (at the \code{x, y} locations).}
\item{d_pred}{a vector of length \code{nrow(XYpred)} of partial derivative (future) predictions.}
\item{Pars}{a matrix of 2 rows, where each the first (second) row
 sets the P-spline paramters for \code{x (y)}: \code{min max nseg bdeg lambda pord}. See the argument above.}
\item{cv}{root leave-one-out CV or root average PRESS.}
\item{XYpred}{a matrix with two columns \code{(x, y)} that give the coordinates
of (future) prediction; the default is the data locations.}
}
\description{
\code{ps2D_PartialDeriv} provides the partial derivative
P-spline surface along \code{x}, with aniosotripic penalization of
tensor product B-splines.
}
\details{
This is support function for \code{sim_vcpsr}.
}
\references{
Marx, B. D. (2015). Varying-coefficient single-index signal
regression. \emph{Chemometrics and Intelligent Laboratory Systems}, 143, 111–121.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Brian Marx
}
