% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pssignal.R
\name{plot.pssignal}
\alias{plot.pssignal}
\title{Plotting function for \code{psSignal}}
\usage{
\method{plot}{pssignal}(x, ..., se = 2, xlab = "", ylab = "", col = "black", lty = 1)
}
\arguments{
\item{x}{the P-spline x, usually from \code{psSignal}.}

\item{...}{other parameters.}

\item{se}{a scalar, e.g. \code{se = 2} to produce twice se bands, set \code{se} > 0 (or set \code{se = 0} to supress).}

\item{xlab}{label for the x-axis, e.g. "my x" (quotes required).}

\item{ylab}{label for the y-axis, e.g. "my y" (quotes required).}

\item{col}{color.}

\item{lty}{line type for plotting e.g. \code{lty = 2}.}
}
\value{
\item{Plot}{a plot of the smooth P-spline signal coefficent vector, with or without standard error bands.}
}
\description{
Plotting function for signal regression P-spline smooth coefficients (using \code{psSignal} with \code{class pssignal}), with or
without standard error bands.
}
\examples{
library(JOPS)
# Get the data
library(fds)
data(nirc)
iindex=nirc$x
X=nirc$y
sel= 50:650 #1200 <= x & x<= 2400
X=X[sel, ]
iindex=iindex[sel]
dX=diff(X)
diindex=iindex[-1]
y=as.vector(labc[1,1:40])
oout = 23
dX=t(dX[,-oout])
y=y[-oout]
fit2 = psSignal(y, dX, diindex, nseg = 25,lambda = 0.0001)
plot(fit2, se = 2, xlab = 'Coefficient Index', ylab= "ps Smooth Coeff")
title(main='25 B-spline segments with tuning=0.0001')
names(fit2)

}
\references{
Marx, B.D. and Eilers, P.H.C. (1999). Generalized linear regression for sampled signals and
       curves: A P-spline approach. \emph{Technometrics}, 41(1): 1-13.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
