% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binit.R
\name{binit}
\alias{binit}
\title{Translated number vector to bin index.}
\usage{
binit(x, xmin = min(x), xmax = max(x), nbin = 100)
}
\arguments{
\item{x}{a numerical vector.}

\item{xmin}{the lower limit of the domain.}

\item{xmax}{the upper limit of the domain.}

\item{nbin}{the number of bins (default=100).}
}
\value{
A list with components:
\item{xbin}{a vector of \code{length(x)} with elements giving the bin index.}
\item{xgrid}{a vector of \code{length(nbin)} with the midpoints of the bins.}
\item{nbin}{the number of bins.}
}
\description{
Translates number vector to bin index, given lower and
upper limits of the domain and number of bins. A support function
for (smoothing) histograms.
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
