% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kauindex.R
\name{kauindex}
\alias{kauindex}
\title{Kau Index}
\usage{
kauindex(posabund, negabund, pseudo = 1e-05, nazeros = TRUE)
}
\arguments{
\item{posabund}{The abundance of the bacteria in the IgA positive/high fraction (abundances should sum to 1 not as a \%).}

\item{negabund}{The abundance of the bacteria in the IgA negative/low fraction (abundances should sum to 1 not as a \%).}

\item{pseudo}{Pseudo count added to both the IgA positive and negative fraction values prior to calculation. Defaults to 1e-5. Recommend setting to minimum observed abundance in whole dataset.}

\item{nazeros}{Return NA if the pos and neg abundances are both zero. Default is TRUE.}
}
\value{
A numeric value for the Kau index as defined in Kau et al. (2015, \doi{10.1126/scitranslmed.aaa4877}).
}
\description{
This function calculates the immunoglobulin A (IgA) Index as defined in Kau et al. (2015, \doi{10.1126/scitranslmed.aaa4877}) for a single taxon in a single sample.
}
\examples{
kauindex(posabund=0.1,negabund=0.2,pseudo=0.0002)
}
\keyword{Kau}
\keyword{iga}
\keyword{iga-seq}
\keyword{index}
