#' Metadata for the OligoMM12-Colitis experiment used as an example in the IgAScores package
#'
#' @description
#'
#' Metadata associated with the oligoSpecies data set.
#'
#' @details
#'
#' Metadata for an experiment where mice with a defined gut microbiota (OligoMM12) were either given *Helicobacter hepaticus* and IL10R antibody or the antibody alone (the first developing colitis).
#' These data accompany the species level counts in oligoSpecies and also include a negative extraction control. A subset of the combined condition were not properly colonised by *H.hepaticus* and excluded from later analyses.
#' Further details can be found in Jackson et al. (2020, \doi{10.1101/2020.08.19.257501}).
#'
#' @docType data
#'
#' @usage data(oligoMeta)
#'
#' @format An object of class \code{"tibble"}.
#'
#' @keywords dataset metadata oligoMM12 colitis ail10r helicobacter
#'
#' @references To come...
#'
#' @examples
#' data(oligoMeta)
"oligoMeta"
