% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoPerformance_SkewCV.R
\name{GeoPerformance_SkewCV}
\alias{GeoPerformance_SkewCV}
\title{Function to calculate the skewness and coefficient of variance for a set of geographic range calculations}
\usage{
GeoPerformance_SkewCV(GeoRange)
}
\arguments{
\item{GeoRange}{- Data matrix containing the geographic range calculations for a set of taxa, as from the GeoRange_MultiTaxa() function}
}
\value{
Returns a list of the skewness and coefficient of variance for each geographic range measure
}
\description{
Function to calculate the skewness and coefficient of variance for a set of geographic range calculations
}
\note{
The coefficient of variance returned is standard deviation/mean
}
\examples{
\dontrun{
data(BivalvePBDB)
BivalveMatrix<-CoordList_PBDB(BivalvePBDB)
BivalveGeo<-GeoRange_MultiTaxa(OccMatrix=BivalveMatrix,TaxaStart=3)
GeoPerformance_SkewCV(BivalveGeo)
}
}
\seealso{
See the raster and moments packages for more details on the calculation of skewness and coefficient of variance
}
