% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInferenceSystem.R
\name{convertfis}
\alias{convertfis}
\title{Convert a fis}
\usage{
convertfis(fis, option = "s2n", ...)
}
\arguments{
\item{fis}{the fis object to be converted}

\item{option}{the convert option.'s2n': singleton to non-singleton}

\item{...}{For 's2n': fuzzification.method, fuzzification.params, firing.method.
See details below for more information.}
}
\value{
Membership grade(s)
}
\description{
Convert a fis object from one type to another (e.g. from singleton to non-singleton)
}
\details{
\itemize{
\item fuzzification.method, fuzzification.params, firing.method - see \code{\link{addvar}}
}

Usage:
\enumerate{
\item convertfis(fis, option, mf.params, fuzzification.method, fuzzification.params)
\item convertfis(fis, option, mf.params, fuzzification.method, fuzzification.params, firing.method)
}
}
\examples{
fis <- tipper()
fis.ns.1 <- convertfis(fis, option='s2n', fuzzification.method='gauss', fuzzification.params=1)
fis.ns.2 <- convertfis(fis, option='s2n', fuzzification.method='gauss', fuzzification.params=1,
                         firing.method='tnorm.min.max')
}
\author{
Chao Chen
}
