% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_stand.R
\name{new_fe_stand}
\alias{new_fe_stand}
\title{Constructor for the \strong{fe_stand} Class}
\usage{
new_fe_stand(x = list(), ..., class = character())
}
\arguments{
\item{x}{An appropriate \code{list} object}

\item{...}{Additional arguments required for enabling subclasses of
\code{fe_stand}}

\item{class}{A Character string required for enabling subclasses of
\code{fe_stand}}
}
\value{
An object of class \code{fe_stand}
}
\description{
Should be used by expert users only who know exactly what they are doing.
Other users please take the function \code{\link{fe_stand}} for creating an
object of that class.
}
\examples{
# Constructing a minimal fe_stand object from scratch
# Use fe_stand() if you are not absolutely sure

trees <- data.frame(
  tree_id = as.character(c(1:100)),
  species_id = as_fe_species_tum_wwk_short(rep("5", 100)),
  layer_key = 1,
  time_yr = 2022,
  dbh_cm = rnorm(100, 50, 8),
  age_yr = NA_real_,
  height_m = NA_real_,
  crown_base_height_m = NA_real_,
  crown_radius_m = NA_real_,
  removal = FALSE,
  ingrowth = FALSE,
  n_rep_ha = 1 / 0.75
)

fe_stand_candidate <- list(
  stand_id = "my_interesting_stand",
  area_ha = 0.75,
  small_trees = data.frame(),
  trees = trees
)

fe_stand_object <- new_fe_stand(fe_stand_candidate)

# Better validate it
fe_stand_object |> validate_fe_stand()

}
